<?php
/**
 * Шаблон Bloody для CS:Bans 1.3
 * -----------------------------
 * Версия: 1.16
 * Автор:  Z.Gaming Pro Team
 * -----------------------------
 * http://zgaming-pro.com/
 * -----------------------------
 * Страница управления логами
 * -----------------------------
 * @author Craft-Soft Team
 * @package CS:Bans
 * @version 1.3
 * @copyright (C)2013 Craft-Soft.ru.  Все права защищены.
 * @link http://craft-soft.ru/
 * @license http://creativecommons.org/licenses/by-nc-sa/4.0/deed.ru  «Attribution-NonCommercial-ShareAlike»
 */
$this->pageTitle='Системный лог - Админцентр - '.Yii::app()->name;
$this->breadcrumbs=array('Админцентр'=>array('/admin/index'),'Системный лог');
$this->menu=array(array('label'=>'Удалить все записи','url'=>'#','linkOptions'=>array('id'=>'clearLog')));
Yii::app()->clientScript->registerScript('', '
	$("a#clearLog").click(function(){
		if(!confirm("Удалить все записи лога?"))
			return false;

		var ret = "";

		$.post("", {"clearlog": 1}, function(data){
			jQuery("#logs-grid").yiiGridView("update");
			alert("Лог очищен");
		});
		return false;
	});
');
?>
<div id="container">
    <div class="con_tit red">Системный лог</div>
    <div class="p_main">
        <?php $this->renderPartial('/admin/mainmenu',array('active'=>'site','activebtn'=>'logs'));?>
        <div class="p_main_con">
            <div class="p_man_l">
<?php
$criteria = new CDbCriteria();
$criteria->group='username';
$this->widget('bootstrap.widgets.TbGridView',array(
	'id'=>'logs-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'afterAjaxUpdate' => 'reinstallDatePicker',
	'columns'=>array(
		array(
			'name' => 'timestamp',
			'type' => 'datetime',
			'value' => '$data->timestamp',
			'filter' => $this->widget('zii.widgets.jui.CJuiDatePicker', array(
				'model' => $model,
				'id' => 'timestamp',
				'attribute' => 'timestamp',
				'language' => 'ru',
				'i18nScriptFile' => 'jquery-ui-i18n.min.js',
				'htmlOptions' => array(
					'id' => 'timestamp',
					'size' => '10',
				),
				'options' => array(
					'showAnim'=>'fold',
					/*'dateFormat'=>'yy-mm-dd',
					'changeMonth' => 'true',
					'changeYear'=>'true',*/
				)
			), true),
		),
		array(
			'name' => 'username',
			'filter' => CHtml::listData(Logs::model()->findAll($criteria), 'username', 'username'),
		),
		array(
			'name' => 'action',
			'value' => 'Logs::getLogType($data->action)',
			'filter' => Logs::getLogType(FALSE, TRUE),
		),
		array(
			'class'=>'bootstrap.widgets.TbButtonColumn',
			'template' => '{view} {delete}',
		),
	),
));
Yii::app()->clientScript->registerScript('re-install-date-picker', "
	function reinstallDatePicker(id, data) {
		$('#timestamp').datepicker(jQuery.extend({showMonthAfterYear:false},jQuery.datepicker.regional['ru'],{'showAnim':'fold'}));
	}
");
?>
            </div>
            <div class="cle_h"></div>
        </div>
        <div class="p_main_bottom"></div>
    </div>
</div>