<?php
/**
 * Шаблон Bloody для CS:Bans 1.3
 * -----------------------------
 * Версия: 1.16
 * Автор:  Z.Gaming Pro Team
 * -----------------------------
 * http://zgaming-pro.com/
 * -----------------------------
 * Главная страница серверов
 * -----------------------------
 * @author Craft-Soft Team
 * @package CS:Bans
 * @version 1.3
 * @copyright (C)2013 Craft-Soft.ru.  Все права защищены.
 * @link http://craft-soft.ru/
 * @license http://creativecommons.org/licenses/by-nc-sa/4.0/deed.ru  «Attribution-NonCommercial-ShareAlike»
 */
$this->pageTitle='Список серверов - '.Yii::app()->name;
$this->breadcrumbs=array('Серверы',);
Yii::app()->clientScript->registerScript('serverview', '
$(".servtr").live("click", function(){
	$("#loading").show();
	var sid = this.id.substr(6);
	$.post(
		"'.Yii::app()->urlManager->createUrl('/serverinfo/serverdetail').'",
		{
			"'.Yii::app()->request->csrfTokenName.'": "'.Yii::app()->request->csrfToken.'",
			"sid": sid
		},
		function(data){
			eval(data);
		}
	);
});
');
?>
<div id="container">
    <div class="con_tit red">Серверы</div>
    <div class="main">
        <div>
            <h2 class="red">Список серверов</h2>
            <div class="hr"></div>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>Мод</th>
                    <th>OS</th>
                    <th>VAC</th>
                    <th>Имя</th>
                    <th>Игроки</th>
                    <th>Карта</th>
                    <th></th>
                </tr>
            </thead>
            <tbody id="servers">
            <?php foreach($servers as $server):?>
                <tr class="warning" id="server<?php echo intval($server['id'])?>">
                    <td colspan="7">
                    <?php echo $server['hostname'].'&nbsp;'.CHtml::image(Yii::app()->baseUrl.'/images/loading.gif');?>
                    </td>
                </tr>
            <?php endforeach;?>
            </tbody>
        </table>
    </div>
    <div class="side">
        <div class="side_tit"><h2>Статистика</h2></div>
        <div class="hr"></div>
        <div class="side_list">
            <ul>
                <li>Всего банов:&nbsp;<span><?php echo $info['bancount'];?></span></li>
                <li>Активные:&nbsp;<span><?php echo $info['actbans'];?></span></li>
                <li>Перманентные:&nbsp;<span><?php echo $info['permbans'];?></span></li>
                <li>Временные:&nbsp;<span><?php echo $info['tempbans'];?></span></li>
                <li>Админов:&nbsp;<span><?php echo $info['admins'];?></span></li>
                <li>Серверов:&nbsp;<span><?php echo $info['serversCount'];?></span></li>
            </ul>
        </div>
    </div>
</div>
<?php $this->beginWidget('bootstrap.widgets.TbModal',array('id'=>'ServerDetail','htmlOptions'=>array('style'=>'width:600px;margin-left:-300px')));?>
<div class="modal-header">
    <a class="close" data-dismiss="modal"  data-placement="bottom">&times;</a>
    <h4>Детали сервера <a id="serverlink" rel="tooltip" data-placement="bottom" data-title="Показать подробности"></a></h4>
    <hr class="hr" />
</div>
<div class="modal-body" id="ban_name">
    <table class="table">
        <tbody>
            <tr>
                <td>Название:</td>
                <td id="server-name"></td>
                <td rowspan="3" id="server-mapimage"></td>
            </tr>
            <tr>
                <td>Адрес:</td>
                <td id="server-address"></td>
            </tr>
            <tr>
                <td>Карта:</td>
                <td id="server-map"></td>
            </tr>
            <tr>
                <td>Игроки:</td>
                <td id="server-players"></td>
                <td id="server-links">
                    <a id="steam-connect" title="Подключиться"><?php echo CHtml::image(Yii::app()->urlManager->baseUrl. '/images/steam-connect.png');?></a>
                    &nbsp;
                    <a id="hlws-add"><?php echo CHtml::image(Yii::app()->urlManager->baseUrl . '/images/hlsw-add.png');?></a>
                </td>
            </tr>
        </tbody>
    </table>
    <hr class="hr" />
    <p class="text-success"><i class="icon-user"></i>&nbsp;Игроки</p>
    <div id="serverinfo-players"></div>
    <hr class="hr" />
</div>
<div class="modal-footer">
<?php $this->widget('bootstrap.widgets.TbButton',array('label'=>'Закрыть','url'=>'#','htmlOptions'=>array('data-dismiss'=>'modal'),));?>
</div>
<?php $this->endWidget();?>
<script>
	$(document).ready(function(){
	<?php foreach($servers as $server):?>
		$.post(
			"<?php echo $this->createUrl('/serverinfo/getinfo')?>",
			{
				'<?php echo Yii::app()->request->csrfTokenName ?>': '<?php echo Yii::app()->request->csrfToken ?>',
				'server': '<?php echo intval($server->id)?>'
			},
			function(data){
				var ret;
				var info = $.parseJSON(data);
				var elem = $('#server<?php echo intval($server->id)?>');
				if(!info)
				{
					ret = '<td colspan="7"><?php echo $server['hostname']?> <b>Не отвечает</b></td>';
					elem.addClass('error');
				}
				else
				{
					ret = '<td style="text-align:center"><img src="' + info.modimg + '" title="' + info.game + '" /></td>' + 
						  '<td style="text-align:center"><img src="' + info.osimg + '" title="' + info.os + '" /></td>' +
						  '<td style="text-align:center"><img src="' + info.vacimg + '" /></td>' + 
						  '<td>' + info.name + '</td>' + 
						  '<td style="text-align:center">' + info.players + '/' + info.playersmax + '</td>' + 
						  '<td>' + info.map + '</td>' + 
						  '<td style="text-align:center"><?php echo CHtml::link('<i class="icon-eye-open"></i>',Yii::app()->createUrl('/serverinfo/view',array('id' => $server->id)),array('rel' => 'tooltip','title' => 'Подробности'))?></td>';
				  elem.addClass('servtr').css('cursor', 'pointer');
				}
				elem.removeClass('warning').html(ret);
			}
		);
	<?php endforeach;?>
	});
</script>