<?php
/**
 * Шаблон Bloody для CS:Bans 1.3
 * -----------------------------
 * Версия: 1.16
 * Автор:  Z.Gaming Pro Team
 * -----------------------------
 * http://zgaming-pro.com/
 * -----------------------------
 * Главная страница
 * -----------------------------
 * @author Craft-Soft Team
 * @package CS:Bans
 * @version 1.3
 * @copyright (C)2013 Craft-Soft.ru.  Все права защищены.
 * @link http://craft-soft.ru/
 * @license http://creativecommons.org/licenses/by-nc-sa/4.0/deed.ru  «Attribution-NonCommercial-ShareAlike»
 */
$this->pageTitle=Yii::app()->name;
?>
<div id="container">
    <div class="main home_l">
        <div>
            <h2 class="red">Последние 10 банов</h2>
            <div class="hr"></div>
        </div>
        <?php
		$this->widget('bootstrap.widgets.TbGridView', array(
			'dataProvider'=>$bans,
			'type'=>'striped bordered condensed',
			'id' => 'bans-grid',
			'template' => '{items} {pager}',
			'enableSorting' => false,
			'rowHtmlOptionsExpression'=>'array(
				"style" => "cursor:pointer;",
				"class" => $data->expired == 1 ? "bantr success" : "bantr",
				"onclick" => "document.location.href=\'".Yii::app()->createUrl("/bans/view", array("id" => $data->bid))."\'"
			)',
			'columns'=>array(
				'player_nick',
				array(
					'name' => 'ban_created',
					'value' => 'date("d.m.Y",$data->ban_created)',
				),
				array(
					'name'=>'ban_length',
					'value' => 'Prefs::date2word($data->ban_length)',
					'htmlOptions' => array(
						'style' => 'width: 130px'
					)
				)
			),
		));
		?>
    </div>
	<div class="main home_r">
        <div>
            <h2 class="red">Сервера</h2>
            <div class="hr"></div>
        </div>
		<table class="table">
			<thead>
				<tr>
					<th>Имя сервера</th>
					<th>Игроки</th>
					<th>Карта</th>
				</tr>
			</thead>
			<tbody id="servers">
				<?php foreach($servers as $server):?>
				<tr 
					class="warning" 
					style="cursor: pointer"
					id="server<?php echo intval($server['id'])?>"
					onclick="document.location.href='<?php echo $this->createUrl('/serverinfo/view', array('id' => $server['id'])) ?>'"
				>
					<td colspan="3">
						<?php echo $server['hostname']?>
						&nbsp;
						<?php echo CHtml::image(Yii::app()->baseUrl . '/images/loading.gif'); ?>
					</td>
				</tr>
				<?php endforeach;?>
			</tbody>
		</table>
	</div>
</div>
<div class="cle"></div>
<script>
	$(document).ready(function(){
	<?php foreach($servers as $server):?>
		$.post(
			"<?php echo $this->createUrl('/serverinfo/getinfo')?>",
			{
				'<?php echo Yii::app()->request->csrfTokenName ?>': '<?php echo Yii::app()->request->csrfToken ?>',
				'server': '<?php echo intval($server['id'])?>'
			},
			function(data){
				var ret;
				var info = $.parseJSON(data);
				var elem = $('#server<?php echo intval($server['id'])?>');
				if(!info)
				{
					ret = '<td colspan="3"><?php echo $server['hostname']?> <b>Не отвечает</b></td>';
					elem.addClass('error');
				}
				else
				{
					ret = '<td>' + info.name + '</td><td>' + info.players + '/' + info.playersmax + '</td><td>' + info.map + '</td>';
				}
				elem.removeClass('warning').html(ret);
			}
		);
	<?php endforeach;?>
	});
</script>