<?php
/**
 * Шаблон Bloody для CS:Bans 1.3
 * -----------------------------
 * Версия: 1.16
 * Автор:  Z.Gaming Pro Team
 * -----------------------------
 * http://zgaming-pro.com/
 * -----------------------------
 * Страница сервера
 * -----------------------------
 * @author Craft-Soft Team
 * @package CS:Bans
 * @version 1.3
 * @copyright (C)2013 Craft-Soft.ru.  Все права защищены.
 * @link http://craft-soft.ru/
 * @license http://creativecommons.org/licenses/by-nc-sa/4.0/deed.ru  «Attribution-NonCommercial-ShareAlike»
 */

$info = $server->getInfo();
$subTitle=($info['name'])?$info['name']:$server->hostname;
$this->pageTitle='Детали сервера '.$subTitle.' - '.Yii::app()->name;
$this->breadcrumbs=array('Серверы'=>array('index'),$info['name'],);
// Если страницу запрашивает аякс, то не отдаем ему жабаскрипт совсем
if(!Yii::app()->request->isAjaxRequest):
if(!Yii::app()->user->isGuest)
{
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/jquery.contextmenu.js');
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl.'/css/jquery.contextmenu.css');
	Yii::app()->clientScript->registerScript('playerAction', "
	setInterval('reloadplayers()', 5000);
	function reloadplayers()
	{
		$.post('',{'".Yii::app()->request->csrfTokenName."': '".Yii::app()->request->csrfToken."'},function(data){ $('#container').html(data); });
	}
	function playeraction(player, action, reason, time)
	{
		var reasontext;
		var profile = false;
		var reason = null;

		switch (action)
		{
			case 'ban':
				reasontext = 'Забанить пользователя'
				break;
			case 'kick':
				reasontext = 'Кикнуть пользователя'
				break;
			case 'message':
				reasontext = 'Отправить сообщение пользователю'
				break;
			default:
				return false;
		}

		if(!confirm(reasontext + ' ' + player + '?')) {
			return false;
		}
		if(action == 'ban')
		{
			var reason = prompt('Введите причину бана', 'Читер');
			var bantime = prompt('Введите время бана в минутах (1440 - сутки, 10080 - неделя, 43200 - месяц)', '1440');
			if(!reason || !bantime) {
				return false;
			}
		}

		if(action == 'message')
		{
			var reason = prompt('Введите сообщение для игрока ' + player, '');
			if(!reason)
			{
				return false;
			}
		}
		$('#loading').show();
		$.post(
			'".Yii::app()->createUrl('/serverinfo/context', array('id' => $server->id))."',
			{
				'ajax': 1,
				'action': action,
				'player': player,
				'reason': reason,
				'time': bantime
			},
			function(data){eval(data);}
		);
	}

	$(function(){
		$.contextMenu({
			selector: '.context-menu-one',
			callback: function(key, options) {
				var player = options.\$trigger.attr('id');
				playeraction(player, key);
			},
			items: {
				'ban': {name: 'Забанить'},
				'separator': '-----',
				'kick': {name: 'Кикнуть'},
				'separator2': '-----',
				'message': {name: 'Отправить сообщение'},
			}
		});
	});
	", CClientScript::POS_END
	);
}
endif;
?>
<div id="container">
    <?php if($info):?>
    <div class="con_tit red">Детали сервера &laquo;<?php echo $info['name'];?>&raquo;</div>
    <div class="main">
        <div>
            <h2 class="red">Игроки</h2>
            <div class="hr"></div>
        </div>
        <?php if(is_array($info['playersinfo']) && !empty($info['playersinfo'])):?>
        <table class="table" id="players">
            <thead>
                <tr>
                    <th>Ник</th>
                    <th style="text-align:center;">Счет</th>
                    <th style="text-align:center;">Время</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach($info['playersinfo'] as $player):?>
                <tr class="context-menu-one" id="<?php echo CHtml::encode($player['name']);?> ">
                    <td><?php echo CHtml::encode($player['name']);?></td>
                    <td style="text-align:center"><?php echo CHtml::encode($player['score']);?></td>
                    <td style="text-align:center"><?php echo function_exists('query_live')?$player['time']:Prefs::date2word(intval($player['time']),FALSE,TRUE);?></td>
                </tr>
            <?php endforeach;?>
            </tbody>
        </table>
        <?php else:?>
        <div class="noplayer alert alert-error">Нет игроков</div>
        <?php endif;?>
		</div>
        <div class="side">
            <div class="side_tit"><h2>Информация</h2></div>
            <div class="hr"></div>
            <?php
            // Ышо колхоз )))
            if(stristr($info['mapimg'],'noimage.jpg')){
                echo str_replace('images/maps/noimage.jpg','themes/bloody/img/no_map.png',$info['mapimg']);
            }else{
                echo $info['mapimg'];
            };
            ?>
            <div class="side_list">
                <ul>
                    <li>Адрес:&nbsp;<span><?php echo CHtml::link(CHtml::encode($server->address),'steam://connect/'.CHtml::encode($server->address),array('onfocus'=>'this.blur()'));?></span></li>
                    <li>Карта:&nbsp;<span><?php echo CHtml::encode($info['map']);?></span></li>
                    <li>Игроки:&nbsp;<span><?php echo CHtml::encode($info['players']).'/'.CHtml::encode($info['playersmax']);?></span></li>
                    <?php if($info['nextmap']):?>
                    <li>Следующая карта:&nbsp;<span><?php echo CHtml::encode($info['nextmap']);?></span></li>
                    <?php endif?>
                    <?php if($info['timeleft']):?>
                    <li>До смены карты:&nbsp;<span><?php echo CHtml::encode($info['timeleft']);?></span></li>
                    <?php endif?>
                    <?php if($info['contact']):?>
                    <li>Контакты:&nbsp;<span><?php echo CHtml::encode($info['contact']);?></span></li>
                    <?php endif?>
                </ul>
            </div>
            <?php if(!Yii::app()->user->isGuest):?><br /><p class="text-success"><i class="icon-exclamation-sign"></i> <i>Нажмите правой кнопкой на игроке для вызова меню</i></p><?php endif;?>
		</div>
        <div class="cle"></div> 
	</div>
	<?php else:?>
    <div class="con_tit red">Детали сервера &laquo;<?php echo $server->hostname;?>&raquo;</div>
	<div class="alert alert-error">Сервер не отвечает. Возможно сервер выключен или сменяет карту</div>
	<?php endif;?>
</div>