
#include <amxmodx>
#include <amxmisc>
#include <sockets_hz>

#define PLUGIN "UCP Screen Uploader"
#define VERSION "1.1"
#define AUTHOR "Endi"

new g_socket
new PATH[64]
new IP[64]
new PORT

public plugin_init(){
	register_plugin(PLUGIN,VERSION,AUTHOR)
}

public plugin_cfg(){
	new buffer[64]
	get_localinfo("amxx_configsdir",buffer,charsmax(buffer))
	format(buffer,charsmax(buffer),"%s/ucp/config.cfg",buffer)
	server_cmd("exec %s",buffer)
	server_exec()
	get_cvar_string("ucp_upload_mode",buffer,charsmax(buffer))
	if(equali(buffer,"LOCAL")){
		get_cvar_string("ucp_upload_host",IP,charsmax(IP))
		get_cvar_string("ucp_upload_path",PATH,charsmax(PATH))
		get_cvar_string("ucp_upload_port",buffer,charsmax(buffer))
		PORT = str_to_num(buffer)
		new error
		g_socket = socket_listen(IP,PORT,SOCKET_TCP,error)
		if(error){
			switch(error){
				case 1:    log_amx("Error creating a TCP socket to %s:%i",IP,PORT)
				case 2:    log_amx("Error resolving the hostname for %s:%i",IP,PORT)
				case 3:    log_amx("Error connecting a TCP socket to %s:%i",IP,PORT)
				}
		} else{
			socket_unblock(g_socket)
			set_task(1.0,"accept",0,"",0,"b")
		}
	}
}

public plugin_end(){
	if( g_socket > 0){
		socket_close(g_socket)
	}
}

public accept() {
	new client = socket_accept(g_socket)
	if(client > 0){
		socket_unblock(client)
		set_task(0.1,"recv",client)
	}
}

public recv(id){
	new buffer[1025]
	if(socket_recv(id,buffer,charsmax(buffer)) > 0){
		if(containi(buffer,".jpg") != -1){
			format(buffer,charsmax(buffer),"%s%s",PATH,buffer)
			new hFile = fopen(buffer,"wb")
			if(hFile){
				new NewPort = random_num(40000,65535)
				new portbuffer[8]
				num_to_str(NewPort,portbuffer,charsmax(portbuffer))
				new error,a,len
				new socket2 = socket_listen(IP,NewPort,SOCKET_TCP,error)
				socket_send2(id,portbuffer,strlen(portbuffer))
				new client 
				log_amx ("Port: %s Upload: %s",portbuffer,buffer)
				if((client = socket_accept(socket2)) > 0){
					a = 0
					while(a != 1){
						len = socket_recv(client,buffer,charsmax(buffer))
						if(len > 0){
							fwrite_blocks(hFile,buffer,len,BLOCK_BYTE)
						} else{
							a = 1
						}
					}
				}
				socket_close(client)
				socket_close(socket2)
			}
			fclose(hFile)
		}
	}
	socket_close(id)
}
