/* Plugin generated by AMXX-Studio */
#include <amxmodx>
#include <amxmisc>

#define PLUGIN "x-warvote"
#define VERSION "0.2"
#define AUTHOR "niro"

// command access level:
#define CMDACCESS ADMIN_USER

//#define DEBUG

#define TID_VOTEEND	144441
#define TID_UNBLOCK	144442

new vyes, vno, vnum, ct_plnum, t_plnum
new menu[32], menunum, menuheader[32]
new command[32], block[2] = {0, 0}, mode, inprogress = 0

public plugin_init() {
	#if defined DEBUG
	server_print("* plugin_init()")
	#endif
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_dictionary("x-war.txt")
	register_dictionary("x-warvote.txt")
	
	register_cvar("xw_vote_delay", "10")
	register_cvar("xw_vote_time", "1")
	register_cvar("xw_vote_ratio", "0.9")
	register_cvar("xw_maxnotvoted_ratio", "0.1")
	
	register_concmd("say cw", "vote_cw", CMDACCESS)
	register_concmd("say cwabort", "vote_cwabort", CMDACCESS)

	new cfgdir[64]
	get_configsdir(cfgdir,63)
	server_cmd("exec %s/x-war/x-warvote.cfg",cfgdir)
}

public vote_cw(id){
	if(vaultdata_exists("cw_initialized")){
		client_print(id, print_chat, "%L", LANG_PLAYER, "notallowed")
		return PLUGIN_HANDLED
	}
	format(command, 31, "cw")
	format(menuheader, 31, "menu_mm_item1")
	mode = 0
	vote_start(id)
	
	return PLUGIN_CONTINUE
}

public vote_cwabort(id){
	if(!vaultdata_exists("cw_initialized")){
		client_print(id, print_chat, "%L", LANG_PLAYER, "notallowed")
		return PLUGIN_HANDLED
	}
	format(command, 31, "cwabort")
	format(menuheader, 31, "menu_mm_item3")
	mode = 1
	vote_start(id)

	return PLUGIN_CONTINUE
}

public vote_start(id){
	#if defined DEBUG
	server_print("* vote_start()")
	#endif
	if (id && !((get_user_flags(id) & CMDACCESS))){ 
		client_print(0, print_chat, "%L", LANG_PLAYER, "clt_noaccess")
		return PLUGIN_CONTINUE
	}
	new players[32], i

	if(block[mode] || inprogress){
		client_print(id, print_chat, "%L", LANG_PLAYER, "notallowed")
		return PLUGIN_CONTINUE
	}
	vyes = 0
	vno = 0
	vnum = 0
	menunum = 0
	get_players(players,ct_plnum,"e","CT")
	for(i=0;i<ct_plnum;i++) if(players[i]!=id) cwmenu_show(players[i])

	get_players(players,t_plnum,"e","TERRORIST")
	for(i=0;i<t_plnum;i++) if(players[i]!=id) cwmenu_show(players[i])
	
	cwmenu_action(id, 0, 0)
	
	set_task(float(get_cvar_num("xw_vote_time")*60), "vote_end", TID_VOTEEND)
	set_task(float(get_cvar_num("xw_vote_delay")*60), "vote_unblock", TID_UNBLOCK+mode)
	block[mode] = 1
	inprogress = 1
	
	return PLUGIN_CONTINUE
}

public vote_unblock(){
	#if defined DEBUG
	server_print("* vote_unblock()")
	#endif
	block[mode] = 0
	
	return PLUGIN_CONTINUE
}

public vote_end(){
	#if defined DEBUG
	server_print("* vote_end()")
	#endif
	new i, need = floatround(get_cvar_float("xw_vote_ratio")*float(vnum), floatround_ceil)
	
	for(i=0;i<menunum;i++) menu_destroy(menu[menunum])

	if((ct_plnum+t_plnum-vnum) >= get_cvar_float("xw_maxnotvoted_ratio")*float(ct_plnum+t_plnum)){
		remove_task(TID_UNBLOCK+mode)
		vote_unblock()
	}
	
	if((vyes>=need) && vnum) server_cmd(command)
	else client_print(0, print_chat, "%L", LANG_PLAYER, "failed", vyes, vno, ct_plnum+t_plnum-vnum, need)
	
	inprogress = 0
	
	return PLUGIN_CONTINUE
}

public client_disconnect(id){
	#if defined DEBUG
	server_print("* client_disconnect(id=%d)", id)
	#endif
	new playerteam[2]
	
	get_user_team(id,playerteam,1)
	switch(playerteam[0]){
		case 'C': ct_plnum--
		case 'T': t_plnum--
	}
	
	return PLUGIN_CONTINUE
}

public cwmenu_action(id, menu, item){
	#if defined DEBUG
	server_print("* cwmenu_action(id=%d, menu=%d, item=%d)", id, menu, item)
	#endif
	if(item == MENU_EXIT) return PLUGIN_HANDLED
	
	vnum++
	(item) ? vno++ : vyes++
	
	if(vnum == ct_plnum + t_plnum){
		remove_task(TID_VOTEEND)
		vote_end()
	}
	
	return PLUGIN_HANDLED
}

public cwmenu_show(id){
	#if defined DEBUG
	server_print("* cwmenu_show(id=%d)", id)
	#endif
	new str[32]
	
	format(str, 31, "%L", id, menuheader)
	menu[menunum] = menu_create(str, "cwmenu_action")
	
	format(str, 31, "%L", id, "menu_yes")
	menu_additem(menu[menunum], str)
	format(str, 31, "%L", id, "menu_no")
	menu_additem(menu[menunum], str)
	menu_setprop(menu[menunum], MPROP_EXIT, MEXIT_NEVER)
	menu_display(id, menu[menunum++], 0)
	
	return PLUGIN_HANDLED
}
